unit graf_fx;

interface

{// N A G L O W K I  P R O C E D U R  I  F U N K C J I}
{///////////////////////////////////////////////////////}

procedure g_ustaw_tryb_vga(tryb : byte);
procedure g_rysuj_piksel_13h( x, y : word; kolor : byte);
procedure g_rysuj_pozioma_linia_13h(x1, x2, y : word; kolor : byte);
procedure g_rysuj_pionowa_linia_13h(x, y1, y2 : word; kolor : byte);
procedure g_zamaluj_ekran_13h(kolor : byte);

implementation

procedure g_ustaw_tryb_vga(tryb : byte);
begin
asm

mov ah, 00h  {zaladuj 00h do AH - numer funkcji przerwania 10h}
mov al, tryb {zaladuj tryb do AL - numer trybu pracy karty graficznej}
int 10h      {wywolaj przerwanie 10h}

end;
end; {koniec procedury g_ustaw_tryb_vga}

{--------------}

procedure g_rysuj_piksel_13h( x, y : word; kolor : byte);
begin
asm

mov ax, y                {zaladuj y do AX}
mov di, ax               {zaladuj AX do DI}
shl ax, 8                {przesun bity rejestru AX 8 pozycji w lewo}
shl di, 6                {przesun bity rejestru DI 6 pozycji w lewo}
add di, ax               {dodaj AX do DI}
add di, x                {dodaj x do DI}
mov ax, 0a000h           {zaladuj A000 do AX}
mov es, ax               {zaladuj AX do ES}
mov al, kolor            {zaladuj kolor do AL}
mov byte ptr es:[di], al {zapisz pod adres ES:DI warto rejestru AL}

end;
end; {koniec procedury g_rysuj_piksel_13h}

{--------------}

procedure g_rysuj_pozioma_linia_13h(x1, x2, y : word; kolor : byte);
begin
asm
mov cx, x2        {zaladuj x2 do CX}
sub cx, x1        {odejmij x1 od CX i umiesc wynik w CX}
add cx, 1         {dodaj 1 do CX}
mov ax,y          {zaladuj y do AX}
mov di,ax         {zaladuj AX do DI}
shl ax,8          {przesun bity rejestru AX o 8 pozycji w lewo}
shl di,6          {przesun bity rejestru DI o 6 pozycji w lewo}
add di,ax         {dodaj AX do DI}
add di,x1         {dodaj x do DI}
mov ax,0a000h     {zaladuj A000 do AX}
mov es,ax         {zaladuj AX do ES}
mov al, kolor     {zaladuj kolor do AL}
cld               {wyzeruj znacznik kierunku - adresy rosnace}
rep stosb         {zapisz CX razy wartosc rejestru AL do komorek
                   pamieci spod adresu ES:DI}
end;
end; {koniec procedury g_rysuj_pozioma_linia_13h}

{--------------}

procedure g_rysuj_pionowa_linia_13h(x, y1, y2 : word; kolor : byte);
begin
asm

mov cx, y2        {zaladuj y2 do CX}
sub cx, y1        {odejmij y1 od CX}
add cx, 1         {dodaj 1 do CX}
mov ax, y1        {zaladuj 1 do AX}
mov di, ax        {zaladuj AX do DI}
shl ax, 8         {przesun bity rejestru AX 8 pozycji w lewo}
shl di, 6         {przesun bity rejestru DI 6 pozycji w lewo}
add di, ax        {dodaj AX do DI}
add di, x         {dodaj x do DI}
mov ax, 0a000h    {zaladuj A000 do AX}
mov es, ax        {zaladuj AX do ES}
mov al, kolor     {zaladuj kolor do AL}

@rysuj_linie:     {definicja etykiety}
mov es:[di], al   {zapisz AL do komorki pamieci o adresie ES:DI}
add di, 320       {dodaj 320 do DI}
loop @rysuj_linie {zmiejsz CX o 1, jezeli rozny od 0 skocz do etykiety rysuj_linie}

end;
end; {koniec procedury g_rysuj_pionowa_linia_13h}

{--------------}

procedure g_zamaluj_ekran_13h(kolor : byte);
begin
asm

mov ax, 0A000h   {zaladuj A000h do AX}
mov es, ax       {zaladuj AX do ES}
mov di, 0        {zaladuj 0 do DI}
mov cx, 32000    {zaladuj 32000 do CX} 
mov ah, kolor    {zaladuj kolor do AH}
mov al, ah       {zaladuj AH, do AL}
cld              {ustwa znacznik kierunku - adres rosnacy}
rep stosw        {zapisz CX razy wartosc rejstru AX do kmorek spod 
                  adresu ES:DI, zwieksz DI o 2}
end;
end; {koniec procedury g_zamaluj_ekran_13h}

end. {koniec modulu}